#version 430

layout (location=0) in vec3 vertexPosition;
layout (location=1) in vec3 vertexNormal;
layout (location=2) in vec2 vertexUV;
layout (location=3) in vec3 vertexTangent;

out vec3 position;
out vec3 normal;
out vec2 uv;
out vec3 tangent;

uniform float g_time;
uniform float g_timeStep=0.0;
uniform float g_emit = 1.0;
uniform float g_uvScale = 1.0;

uniform mat4 modelMatrix;

vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}


void main() {
  gl_Position = vec4(vertexPosition, 1.0);

  float emit = g_emit;

  normal = vertexNormal;
  tangent = vertexTangent;
  if (emit < 0.5) {

    position = vertexPosition*(1.0+(g_timeStep*0.7))+vec3(0.0, 0.00, 0.0); // (modelMatrix*vec4(vertexPosition, 0.0)).xyz;
    float d = dot(position, position);
   // d = abs(position.x)*10.0;
    uv = vertexUV;
  //  position += 0.001*normal*sin(sqrt(d*1.1));
  //  normal = rotateXZ3(normal.xyz, 0.03*sin(sqrt(d*0.001))).xyz;
  //  tangent = rotateXZ3(tangent.xyz, 0.03*sin(sqrt(d*0.001))).xyz;
   // position.y = abs(position.y);
  } else {
    // emit a new
    //  position = vertexPosition+vec3(0.1, 0.0, 0.0);
    position = (modelMatrix*vec4(vertexPosition, 1.0)).xyz;
    //uv = vertexUV;
    uv = vec2(position.x*1.1+position.z*0.05, position.x*0.1+position.z*1.07+position.y*0.23)*g_uvScale;
  }


}
